<?php
/**
* DS-Syndicate component for Joomla 1.0
* Author:  Martin Diphoorn
* Copyright 2006 Martin Diphoorn
* License:  GNU General Public License
* Version 1.0.3
*
* The pinger is not supported and will only be updated when people send me code.
*
*/
define( "_VALID_MOS", 1 );
global $mosConfig_absolute_path, $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix;

require("../../configuration.php");
require("$mosConfig_absolute_path/includes/joomla.php");
require("$mosConfig_absolute_path/includes/sef.php");
require("$mosConfig_absolute_path/administrator/components/com_ds-syndicate/ds-syndicate.class.php");
require("$mosConfig_absolute_path/components/com_ds-syndicate/includes/IXR_Library.inc.php");
?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>DS-Syndicate Ping</title>
<link rel="stylesheet" href="css/admin.css" type="text/css" />
<link rel="stylesheet" href="../includes/js/ThemeOffice/theme.css" type="text/css" />

<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<style>
				body {
					color:black;
					font-family:Verdana, Arial, Helvetica, sans-serif;
					font-size:12px;
				}

				.pingLink {
					width:150px;
					float:left;
				}
				.pingStatusSuccess {
					color:green;
				}
				.pingStatusFailure {
					color:red;
				}
			</style>
</head>

<body>
<?
$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );

ping();

function ping() {
	global $database, $mosConfig_live_site,$mosConfig_sitename, $mosConfig_offset;

	$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );
	//get last published item

	$database->setQuery("SELECT #__content.publish_up FROM  #__content ORDER BY publish_up DESC LIMIT 1");
	$lastPubDate=$database->loadResult();


	$database->setQuery("SELECT id,name,url,endpoint,lastSuccessfulPingDate FROM `#__dssyndicate_pingers` where published = 1 and lastSuccessfulPingDate < '$lastPubDate'");
	$result=$database->loadObjectList();


	if (count($result)>0) {
		echo "Pinging...";
		foreach($result as $row){
			$rpcError="";
			$rpcStatus="";
			// Specifying a server by URL (port 80 is assumed):
			$client = new IXR_Client("$row->endpoint");

			echo "<p><a href=\"$row->url\" target=\"_blank\" class=\"pingLink\">". $row->name."</a>";
			// Run a query for PHP
			if (!$client->query("weblogUpdates.ping", $mosConfig_sitename, $mosConfig_live_site)) {
				$rpcError = '<strong class="pingStatusFailure">Something went wrong - '.$client->getErrorCode().' : '.$client->getErrorMessage()."</strong>";
				echo $rpcError;
				continue;
			}

			$response = $client->getResponse();
			if(($rpcError!="") || (intval($response["flerror"])!=1))
				$rpcStatus = "Success";
			else {
				$rpcStatus = "Failure" . " - ".$response["message"];
			}
			echo "<strong class=\"pingStatus$rpcStatus\">$rpcStatus</strong>";
			// Display the result
			if (isset($_REQUEST['debug'])) {
				echo '<pre>';
				print_r($client->getResponse());
				echo '</pre>';
			}
			echo "</p>";
			$pingUpdate = new mosdssyndicatePinger( $database );
			$pingUpdate->load($row->id);

			$pingUpdate->lastSuccessfulPingDate = $now;
			$dbUpdate=$pingUpdate->store();
			if(!$dbUpdate)
				echo "Error updating database.";
		}
	}
	else {
		echo "<p>There has been no new published items since the last time the aggregator sites were last pinged.</p><p>Now: $now<br/>LastPub: $lastPubDate</p>";
	}
}
?>
</body>
</html>