<?php
/*
* DS-Syndicate component for Joomla 1.0
* Author:  Martin Diphoorn
* Copyright 2006 Martin Diphoorn
* License:  GNU General Public License
* Version 1.1.1
*/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// Set feedcreator to label timestamps as GMT for Atom/RSS1.0
define("TIME_ZONE","");
include($mosConfig_absolute_path."/components/com_ds-syndicate/includes/feedcreator.class.php");

global $database, $mainframe, $my, $Itemid, $mosConfig_MetaDesc;

require_once( $mainframe->getPath( 'class' ) );


//Backward compatibility support
if (mosGetParam( $_GET,'version',"") == 1) {
  new_feed (mosGetParam( $_GET, 'feed_id', ""));
} else {
  old_feed();
}

function new_feed ($feed_id) {

	global $database, $mainframe, $my, $Itemid, $mosConfig_MetaDesc;

	$feed_prop = new mosdssyndicate($database);

	//retrieve the feed properties
	$mysql = "SELECT * FROM #__dssyndicate_feeds WHERE id=" . $feed_id;
	$database->setQuery( $mysql );
	$feed_props = $database->loadObjectList();

	foreach ($feed_props as $feed_prop) {
	  $cur_feed = $feed_prop;
	}

	$lists['feedid']             = $cur_feed->id; /*<<>> MAD 2007/09/28 */
	$lists['title']              = $cur_feed->feed_name;
  	$lists['type']               = $cur_feed->feed_type;
  	$lists['sectlist']           = $cur_feed->msg_sectlist;
  	$lists['excatlist']          = $cur_feed->msg_excatlist; /*<< AGE 2007/09/25 */
  	$lists['fulltext']           = $cur_feed->msg_fulltext;  /*<<>> MAD 2007/10/09 */
  	$lists['cat']                = $cur_feed->msg_sectcat;
 	$lists['count']              = $cur_feed->msg_count;
 	$lists['orderby']            = $cur_feed->msg_orderby;
 	$lists['cache']              = $cur_feed->feed_cache;
	$lists['docache']            = intval($lists['cache'])>0?1:0;
	$lists['description']        = $cur_feed->feed_description;
	$lists['renderAuthorFormat'] = $cur_feed->feed_renderAuthorFormat; //NAME, EMAIL, NAME&EMAIL
	$lists['renderHTML']         = intval($cur_feed->feed_renderHTML);
	$lists['renderImages']       = intval($cur_feed->feed_renderImages);
	$lists['FPItemsOnly']        = $cur_feed->msg_FPItemsOnly;
  	$lists['numWords']           = $cur_feed->msg_numWords;
  	$lists['imgUrl']             = $cur_feed->feed_imgUrl;
	$lists['catsInTitle']        = 1; // default = 1
	$lists['catsInTitle']        = intval($cur_feed->feed_catsInTitle);

	create_feed($feed_id, $lists );
}


//Display the old_feed
function old_feed () {

	global $database, $mainframe, $my, $Itemid, $mosConfig_MetaDesc, $mosConfig_sitename;


	$row = new mosdssyndicate( $database );
 	$row->load( 1 );

  	$lists['feedid']        = -1; /*<< MAD 2007/09/28 */
  	$lists['type']			= mosGetParam( $_GET, 'type', "rss" );
	$lists['docache']			= mosGetParam( $_GET, 'nocache', 0 );
  	$lists['cat']			= mosGetParam( $_GET, 'cat', "");
  	$lists['sectlist']		= mosGetParam( $_GET, 'sectlist', "");
  	$lists['excatlist']		= mosGetParam( $_GET, 'excatlist', ""); /*<< AGE 2007/09/25 */

	$lists['title']			= htmlspecialchars($mosConfig_sitename);
 	$lists['count']			= $row->count;
 	$lists['orderby']			= $row->orderby;
 	$lists['cache']			= $row->cache;
	$lists['description']		= $row->description;
	$lists['renderAuthorFormat']	= $row->renderAuthorFormat; //NAME, EMAIL, NAME&EMAIL
	$lists['renderHTML']		= intval($row->renderHTML);
	$lists['renderImages']		= true;
	$lists['FPItemsOnly']		= $row->FPItemsOnly;
  	$lists['numWords']		= $row->numWords;
  	$lists['imgUrl']			= $row->imgUrl;
	$lists['catsInTitle']		= 1;

	create_feed( 0, $lists );

}

function create_feed ( $feedid, &$lists ) {

	global $database, $mainframe, $my, $Itemid, $mosConfig_MetaDesc, $mosConfig_offset, $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_sitename, $mosConfig_sef;

	add_stats($lists); /*<< MAD 2007/09/28 */

	if ($lists['cat'] != "") {
		$tmp_cats = explode(",", $lists['cat']);
		$cats = "";
		foreach ($tmp_cats as $tmp_cat) {
			if ($cats == "") {
				$cats = "\nAND (c.title = '$tmp_cat' ";
			} else {
				$cats .= "\nOR c.title = '$tmp_cat' ";
			}
		}
		$cats .= ") ";

/*		$cats = "AND c.id IN ($lists['cat']) ";       parameter must be used to precise if title or id is used... also fix catsInTitle functionnality ! */
	}

	$now = date( "Y-m-d H:i:s",time()+$mosConfig_offset*60*60 );


	//if type is Summaries then get numwords from db
	$numWords = ($lists['numWords'] > 0 ) ? $lists['numWords'] : 10000; // numWord == 0 represents ALL

	//if type is RSS then use admin defined default
 	if (($lists['type']=="RSS") || ($lists['type']=="RSSSUMM"))
		$lists['type'] = "RSS".$row->defaultType;

	switch (strtolower( $lists['orderby'] )) {
		case 'date':
			$orderby = "a.created";
			break;
		case 'rdate':
			$orderby = "a.created DESC";
		  	break;
		case 'catsect':
			$orderby = "f.ordering, a.ordering ASC, a.catid, a.sectionid";
			break;
	    case 'artord':
	        $orderby = "a.ordering";
	        break;
	}

	//make a feed id based filename
	$filename = $mosConfig_absolute_path."/components/com_ds-syndicate/feed/feed".$feedid.".xml";
	$rss = new UniversalFeedCreator();

	//Use cache if docache is set to 1
	if (intval($lists['docache'])==1) {
	    $rss->useCached($lists['type'],$filename,$lists['cache']); // use cached version if age<1 hour. May not return!
	}
	$rss->title 				= htmlspecialchars($lists['title']);
	$rss->description			= $lists['description'];
	$rss->link 				= $mosConfig_live_site;
	$rss->syndicationURL 			= $_SERVER['SERVER_NAME']. $_SERVER["PHP_SELF"];
	$rss->descriptionHtmlSyndicated 	= true;

	$image 					= new FeedImage();
	$image->title 				= $mosConfig_sitename;
	$image->url 				= $lists['imgUrl'];
	$image->link 				= $mosConfig_live_site;
	$image->description			= $mosConfig_sitename;
	$image->descriptionHtmlSyndicated	= true;

	if ( $lists['imgUrl']!="") { $rss->image = $image; }

	if ($lists['catsInTitle']) {
		$rss->title .= " (".htmlspecialchars($lists['cat']).")";
	}

	/* SELECT construction */
	/* >> MAD 2007/10/09 */
	$query 	=  "SELECT a.*, a.introtext as itext, a.fulltext as mtext, u.name AS author, u.usertype, u.email as authorEmail, a.created_by_alias as authorAlias, UNIX_TIMESTAMP( a.created ) AS dsdate, c.name as catName "
		;
	/* >> MAD 2007/10/09 */
	/* FROM */
	$query	.=  "\nFROM #__content AS a"
		;
	/* JOIN construction */
	if (intval($lists['FPItemsOnly'])==1) {
		// frontpage Items only
		$query 	.= "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
			;
	}
	$query 	.= "\nLEFT JOIN #__users AS u ON u.id = a.created_by"
		.  "\nLEFT JOIN `#__categories` as c on c.id = a.catid "
		.  "\nLEFT JOIN `#__sections` as s on s.id = c.section "
		;
	/* WHERE construction  */
	$query	.= "\nWHERE a.state='1'"
		;
	if ($lists['sectlist']!="") {
		$query	.= "\n AND s.id IN (" . $lists['sectlist'] . ")"
			;
	}

	if ($lists['excatlist']!="") {
		$query	.= "\n AND c.id NOT IN (" . $lists['excatlist'] . ")"
			;
	}

	$query	.= "\n AND a.access <= 0"	// item only public access check
		.  "\n AND c.access <= 0"	// category only public access check
		.  "\n AND s.access <= 0"	// section only public access check
		.  "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now')"
		.  "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now')"
		;
	/* ORDER BY, LIMIT ...  construction */
	$query	.= "\nORDER BY $orderby"
		.  ($lists['count'] ? (" LIMIT " . $lists['count']) : "")
		;

	$database->setQuery( $query );
	$rows = $database->loadObjectList();
	// Include menu itemid's in URLs by forming $itemids lookup array
	$itemids = makeMenuItemArray('content_blog_section');
	foreach ($rows as $row) {
		$item 		 = new FeedItem();
		$item->title = htmlspecialchars($row->title);
		$itemid		 = $itemids[$row->sectionid];

		// be sure itemid has some content!
		/*>>> AGE 20071012 */
		if ($itemid == "") $itemid = $mainframe->getItemid( $row->id, 0, 0 );
		/*<<< AGE 20071012 */
		if ($itemid == "") {$itemid = 99999999;}
		$itemurl = "index.php?option=com_content&task=view&id=" . $row->id . "&Itemid=" . $itemid;
		$item->link = ($mosConfig_sef == "1") ? sefRelToAbs($itemurl) : $mosConfig_live_site . "/" . $itemurl;

        /* >> MAD 2007/10/09 */
        /* fulltext options:
         * 0 -> Do nothing
         * 1 -> Read more link
         * 2 -> Add to intro text
         */
           
		$words = $row->itext;
		if ($lists['fulltext'] == 2) {
			$words .= $row->mtext;
		}
		
		// Check if $words is larger then the $numWords
		// Add some extra words because characters are count as words (20% extra)
		if (str_word_count(trim($words)) > ($numWords * 1.20)) {
		    $AddReadMoreLink = true;
		    $words = word_limiter($words,($numWords * 1.20),"");
		}
				
		if ($lists['fulltext'] == 1 or $AddReadMoreLink) {
			if (strlen(trim($row->mtext)) > 0 or $AddReadMoreLink)
			    $words .= "\n<p><a href=\"" . $item->link . "\">" . _READ_MORE . "</a></p>";
		}
		
		/* << MAD 2007/10/09 */
		
		if (!$lists['renderHTML']) {
		  /* remove HTML tags */
		  $words = noHTML ($words);

		  /* remove mosimage tags */
		  $words = ereg_replace("{mosimage}", "", $words);

		} else {
		  $image = $row->images;
		  $image = explode( "|", trim($image) );
		  $image = $image[0];

		  if ($image != ""){
			$image = '<img src="' .$mosConfig_live_site .'/images/stories'. $image .'" align="left" border="0" alt="" />';
		  }

		  $words = $image . $words;
		  $words = ereg_replace("{mosimage}", "", $words);

		  if (!$lists['renderImages']) {
		    $words = delImagesFromHTML($words);
		  }

		}

		/* Convert relative urls to absolute */
		$row->itext = addAbsoluteURL($row->itext);

		$item->description 			= $words;
		$item->descriptionHtmlSyndicated	= true;
		$item->date 				= intval($row->dsdate);
		$item->source 				= $mosConfig_live_site;
		$author = trim($row->authorAlias);
		if (empty($author)) $author = $row->author;
		$item->author 				= ($lists['renderAuthorFormat'] == 'NAME') ? $author : (($lists['renderAuthorFormat'] == 'EMAIL') ? $row->authorEmail : $author.' <'.$row->authorEmail.'>');

		$rss->addItem($item);
	}

	$rss->saveFeed($lists['type'],$filename,true);
}

function add_stats(&$lists) {
  global $database, $mainframe, $my, $Itemid, $mosConfig_MetaDesc;

/*>> AGE 2007/09/28 */
	$query = "SELECT * FROM `#__dssyndicate_settings` LIMIT 1";
	$database->setQuery($query);
	$row = $database->loadObjectList();

	if (!$row || !$row[0]->statsonof) return;
/*<< AGE 2007/09/28 */

  //Statisctics run
  $ipadres = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : $HTTP_SERVER_VARS['REMOTE_ADDR']);
  $sql = "INSERT INTO #__dssyndicate_stats(ip, date, feed) VALUES ('$ipadres', now(),'" . $lists['type'] . "')"; /* <<MAD 2007/09/28 */
  $database->setQuery($sql);
  $database->query();
}

function noHTML($words) {
    $words = preg_replace("'<script[^>]*>.*?</script>'si","",$words);
	$words = preg_replace('/<a\s+.*?href="([^"]+)"[^>]*>([^<]+)<\/a>/is','\2 (\1)', $words);
	$words = preg_replace('/<!--.+?-->/','',$words);
	$words = preg_replace('/{.+?}/','',$words);
	$words = strip_tags($words);
	$words = preg_replace('/&nbsp;/',' ',$words);
	$words = preg_replace('/&amp;/','&',$words);
	$words = preg_replace('/&quot;/','"',$words);

	return $words;
}

/*
** Preparation for generating RSS "Read more" links that include menu itemid's --
** Get all the published content_blog_sections in jos_menu, and create a associative array of
** componentid to id (in content terms, content item id to section (or category?) itemid).
** @param string Any existing type in jos_menu items, such as content_blog_section.
** []fixme: add admin param interface for $type in new_feed(), create_feed(), etc.
** Possible problem: there are likely overlapping componentid's in different menus. Only the last one returned is used.
*/
function makeMenuItemArray($type) {
	global $database;
	$itemids = NULL;

	$database->setQuery("SELECT id, componentid "
						. "\n FROM #__menu "
						. "\n WHERE type = '$type'"
						. "\n AND published = 1");
	$rows = $database->loadObjectList();
	foreach ($rows as $row) {
		$itemids[$row->componentid] = $row->id;
	}
	return $itemids;
}

/*
** Convert all Relative url to Absolute url
*/
function addAbsoluteURL($html) {
	global $mosConfig_live_site;

	$html = preg_replace('@href="(?!http://)(?!https://)([^"]+)"@i', "href=\"{$mosConfig_live_site}\${1}\"", $html);
	$html = preg_replace('@src="(?!http://)(?!https://)([^"]+)"@i', "src=\"{$mosConfig_live_site}\${1}\"", $html);

	return $html;
}

/*
** Delete all the images from the url
*/
function delImagesFromHTML($html) {
  $html = preg_replace('/<img\\s.*>/i','', $html);

  return $html;
}

/* >> MAD 2007/10/09
 * Added function word_limiter
 */
function word_limiter($str, $limit = 100, $end_char = '&#8230;') {
  if (trim($str) == '')
    return $str;
    
  preg_match('/^\s*(?:\S+\s*){1,'. (int) $limit .'}/', $str, $matches);

  if (strlen($matches[0]) == strlen($str))
    $end_char = '';

  return rtrim($matches[0]) . $end_char;
}
/* << MAD 2007/10/09 */
?>