<?php
/**
* DS-Syndicate component for Joomla 1.0
* Author:  Martin Diphoorn
* Copyright 2006 Martin Diphoorn
* License:  GNU General Public License
* Version 1.0.3
*
* This code is not supported by ds-syndicate we use the code supplied by users.
*
*/


define( "_VALID_MOS", 1 );

require("../../configuration.php");
require("$mosConfig_absolute_path/classes/mambo.php");
require("$mosConfig_absolute_path/includes/sef.php");
require("$mosConfig_absolute_path/administrator/components/com_ds-syndicate/ds-syndicate.class.php");
require("includes/blogger.php");
require("includes/metaweblog.php");
require("$mosConfig_absolute_path/components/com_ds-syndicate/includes/IXR_Library.inc.php");

$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );

class mamboBloggingServer extends IXR_IntrospectionServer {
	function mamboBloggingServer() {
		 $this->IXR_IntrospectionServer();
		// Now add the callbacks along with their introspection details
		$this->addCallback(
			'metaWeblog.newPost',  // XML-RPC method name
			'api_metaWeblog_newPost',       // function to calback
			array('string', 'string', 'string', 'string', 'struct', 'boolean'), // Array specifying the method signature; first param is return type
			'Adds a new item.'  // Documentation string
		);
		$this->addCallback(
			'metaWeblog.getPost',
			'api_metaWeblog_getPost',
			array('struct','string','string','string'),
			'Retrieves a post'
		);
		$this->addCallback(
			'metaWeblog.editPost',
			'api_metaWeblog_editPost',
			array('boolean','string','string','string','struct','boolean'),
			'Edits an item'
		);
		$this->addCallback(
			'metaWeblog.getRecentPosts',
			'api_metaWeblog_getRecentPosts',
			array('struct','string','string','string','int'),
			'Returns recent weblog items.'
		);
		$this->addCallback(
			'metaWeblog.getCategories',
			'api_metaWeblog_getCategories',
			array('struct','string','string','string'),
			'Returns the categories for a given blog'
		);
		$this->addCallback(
			'api_metaWeblog_newMediaObject',
			'api_metaWeblog_newMediaObject',
			array('struct','string','string','string','struct'),
			'Uploads a file to the server'
		);
		
		$this->addCallback(
			'blogger.getUsersBlogs',
			'api_blogger_getUsersBlogs',
			array('array','string','string','string'),
			'Returns a list of all published categories'
		);
		$this->addCallback(
			'blogger.getPost',
			'api_blogger_getPost',
			array('struct','string','string','string','string'),
			'Returns an item (only the item body!)'
		);
		$this->addCallback(
			'blogger.getRecentPosts',
			'api_blogger_getRecentPosts',
			array('struct','string','string','string','string','int'),
			'Returns recent weblog items.'
		);
		$this->addCallback(
			'blogger.deletePost',
			'api_blogger_deletePost',
			array('boolean','string','string','string','string','boolean'),
			'Deletes a post'
		);
		$this->serve();
	}
}
// Run the server, serve the request
$s = new mamboBloggingServer();

function _newMediaObject($username, $password, $info) {
	global $database, $mosConfig_live_site, $mosConfig_absolute_path;
	$database->setQuery("SELECT id,gid,block,username FROM #__users WHERE username='$username' AND password='".md5($password)."'");
	$database->loadObject($result);
	if((!$result)||!($result->gid>18&&$result->block==0))
		return _error(1,"Login failure.");

	$filename=$info['name'];
	$data=$info['bits'];

	$newFile=@fopen($mosConfig_absolute_path."/images/stories/".$filename, 'w+b');
	if (!$newFile) 
		return new IXR_Error(2,"Unable to create file $filename.");
	$result=@fwrite($newFile, $data);
	@fclose($newFile);
	if (!$result)
		return _error(3,"Unable to save data to file $filename.");
	$url=array("url" => $mosConfig_live_site."/images/stories/".$filename);
	return $url;
}

function _categoryList($section, $username, $password) {
	global $database, $mosConfig_live_site;
	$database->setQuery("SELECT id,gid,block,username FROM #__users WHERE username='$username' AND password='".md5($password)."'");
	$database->loadObject($result);
	if((!$result)||!($result->gid>18&&$result->block==0))
		return new IXR_Error(1,"Login failure.");

	
	$database->setQuery("SELECT defaultType from `#__ds-syndicate` where id = 1");
	$rssType = $database->loadResult();
	
	$categorystruct = array();
	$database->setQuery("SELECT name, description FROM #__categories WHERE section=$section ORDER BY title ASC");
	$result=$database->loadObjectList();

	foreach($result as $row){
		$categorystruct[$row->name] = array(
			"description" => $row->description,
			"htmlUrl" => sefRelToAbs("$mosConfig_live_site/index.php?option=content&task=category&sectionid=$section&id=$row->id"),
			"rssUrl" => "$mosConfig_live_site/index2.php?option=com_ds-syndicate&type=RSS&no_html=1&cat=$row->name"
		);
	}			
	return $categorystruct;
}

function _addItem($blogid, $username, $password, $title, $body, $more, $publish, $closed, $catname = "", $frontpage) {
	global $database, $mosConfig_offset;

	$database->setQuery("SELECT id,gid,block,username FROM #__users WHERE username='$username' AND password='".md5($password)."'");
	$database->loadObject($result);
	if((!$result)||!($result->gid>18&&$result->block==0))
		return _error(1,"Login failure.");

	$database->setQuery("SELECT section,id FROM #__categories WHERE name=\"$catname\"");
	$database->loadObject($result2);
	if(!$result2)
		return _error(4,"Invalid section and/or category.");
	$now=date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );;
	$newContent=new mosContent($database);
	$newContent->title=$title;
	$newContent->title_alias=$title;
	$newContent->introtext=$body;
	$newContent->fulltext="";
	$newContent->state=$publish;
	$newContent->sectionid=$result2->section;
	$newContent->mask=0;
	$newContent->catid=$result2->id;
	$newContent->created=$now;
	$newContent->created_by=$result->id;
	$newContent->created_by_alias="";
	$newContent->modified="";
	$newContent->modified_by="";
	$newContent->checked_out="";
	$newContent->checked_out_time="";
	$newContent->frontpage_up="";
	$newContent->frontpage_down="";
	$newContent->publish_up=$now;
	$newContent->publish_down="";
	$newContent->images="";
	$newContent->attribs="";
	$newContent->version=1;
	$newContent->parentid=0;
	$newContent->ordering=999999;
	$newContent->metakey="";
	$newContent->metadesc="";
	$newContent->access=0;
	$newContent->hits=0;

	$newContent->check();
		
	if($newContent->title=="")
		return _error(5,"Title may not be empty.");
		
	if($newContent->introtext=="")
		return _error(6,"Content may not be empty.");

	$result=$newContent->store();
	if(!$result)
		return _error(7,"Error writing content to database.");
		
	if($frontpage==1){
		$database->setQuery( "INSERT INTO #__content_frontpage (content_id, ordering) VALUES ($newContent->id, 999999)" );
		$database->query();
	}
	return "$newContent->id";
}

function _editItem($postId, $username, $password, $title, $body, $more, $publish, $closed, $catname = "", $frontpage) {
	global $database, $mosConfig_offset;
	
	$database->setQuery("SELECT id,gid,block,username FROM #__users WHERE username='$username' AND password='".md5($password)."'");
	$database->loadObject($result);
	if((!$result)||!($result->gid>18&&$result->block==0))
		return _error(1,"Login failure.");

	$database->setQuery("SELECT section,id FROM #__categories WHERE name=\"$catname\"");
	$database->loadObject($result2);
	if(!$result2)
		return _error(4,"Invalid section and/or category.");
		
	$newContent=new mosContent($database);
	$newContent->load($postId);
		
	$newContent->sectionid=$result2->section;
	$newContent->catid=$result2->id;
	$newContent->title=$title;
	$newContent->title_alias=$title;
	$newContent->introtext=$body;
	$newContent->fulltext="";
	$newContent->state=$publish;
	$newContent->modified=date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );
	$newContent->modified_by=$result->id;
	$newContent->version++;

	$newContent->check();
		
	if($newContent->title=="")
		return _error(5,"Title may not be empty.");
		
	if($newContent->introtext=="")
		return _error(6,"Content may not be empty.");

	$result=$newContent->store();
	if(!$result)
		return _error(7,"Error writing content to database.");
		
	if($frontpage==0){
		$database->setQuery( "DELETE FROM #__content_frontpage WHERE content_id=$postId" );
		$database->query();
	}
	return true;
}

// date helpers
function iso8601_encode($timet, $utc=0) {
	// return an ISO8601 encoded string
	// really, timezones ought to be supported
	// but the XML-RPC spec says:
	//
	// "Don't assume a timezone. It should be specified by the server in its
  // documentation what assumptions it makes about timezones."
	// 
	// these routines always assume localtime unless 
	// $utc is set to 1, in which case UTC is assumed
	// and an adjustment for locale is made when encoding
	if (!$utc) {
		$t=strftime("%Y%m%dT%H:%M:%S", $timet);
	} else {
		if (function_exists("gmstrftime")) 
			// gmstrftime doesn't exist in some versions
			// of PHP
			$t=gmstrftime("%Y%m%dT%H:%M:%S", $timet);
		else {
			$t=strftime("%Y%m%dT%H:%M:%S", $timet-date("Z"));
		}
	}
	return $t;
}

function iso8601_decode($idate, $utc=0) {
	// return a timet in the localtime, or UTC
	$t=0;
	if (ereg("([0-9]{4})([0-9]{2})([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})",
					 $idate, $regs)) {
		if ($utc) {
			$t=gmmktime($regs[4], $regs[5], $regs[6], $regs[2], $regs[3], $regs[1]);
		} else {
			$t=mktime($regs[4], $regs[5], $regs[6], $regs[2], $regs[3], $regs[1]);
		}
	} 
	return $t;
}
?>